#!usr/bin/perl -w
########################################################################
#                                                                      #
# Started:      13/11/2017                                             #
# Author:       John                                                   #
# Contact:      support@hrcompletemanager.com                          #
# Purpose:      Creates a a batch file that updates the registry       # 
#               with current date and time values.                     #
#                                                                      #
# Copyright:    ©hrcompletemanager.com 2022                            #
#               This is free software. Do with is what you wish. It    #
#               comes with no guarantees or warranties. The  author is #
#               not responsible for anything. If you use it and find   #
#               it useful then a thank you would be nice. If you       #
#               use it to make a lot of money then congratulations.    #
#                                                                      #
# WARNING:  	WE USE THIS PROGRAM A LOT                              #
#               IT DOES MORE OR LESS EXACTLY WHAT WE WANT              #
# 	        	IT MAY NOT BE SUITABLE FOR YOU                         #
# 	        	USE IT AT YOUR OWN RISK                                #
#                                                                      #
########################################################################

=head1 DESCRIPTION print;
This utility creates a file called timestamps.reg
which can be run to update the registry.
=cut

use strict;
use warnings;
use File::Find;
use IO::File;
use Env;

#=======================================================================
# USER CONFIGURABLE SECTION
#=======================================================================
# You may need to edit section for your own configuration
#
my $version = "4.3";
# NOTE: The registry path needs to exist (this does not create it)
my $registry = "[HKEY_LOCAL_MACHINE\\insert\\your\\path]";
my $BATCH_FILE  = "timestamps.reg"; # Name of the final file
#=======================================================================
# END OF USER CONFIGURABLE SECTION
#=======================================================================

# Variables stuff
# -------------------
# Set up the date and time values
    (my $sec,my $min,my $hour,my $mday,my $mon,my $year,my $wday,my $yday)=localtime(time);
# Don't forget the system assumes day zero is Jan 1...
    my $myDay = $yday+1;
# Don't forget the system assumes year zero is 1900...
    my $myYear = $year-100;
	my $timestamp = scalar localtime;
# Pad the length of the day part to force 3 digits
    while (length $myDay < 3){
        $myDay="0".$myDay;
    }
	my $mydoy = $myDay;
	my $mySubversion = $myYear.$myDay;
	my $batch = ($year-110).$myDay;
	my $hryear = 1900+$year;
	my $hryearplus2 = $hryear+2;
	my $hrtimestamp = scalar localtime;
	my $hrdaystamp = substr(localtime, 0, 3);
	my $hrmonth = substr(localtime, 4, 3);

# Populate the batch file
# -----------------------
    open fhBATCHFILE,'> '.$BATCH_FILE;
	print fhBATCHFILE "REGEDIT4\n\n";
	print fhBATCHFILE "$registry\n";
	print fhBATCHFILE "\"BATCH\"=\"$batch\"\n";
	print fhBATCHFILE "\"DAY\"=\"$hrdaystamp\"\n";
	print fhBATCHFILE "\"DAY_OF_YEAR\"=\"$mydoy\"\n";
	print fhBATCHFILE "\"MONTH\"=\"$hrmonth\"\n";
	print fhBATCHFILE "\"SUBVERSION\"=\"$mySubversion\"\n";
	print fhBATCHFILE "\"TIMESTAMP\"=\"$timestamp\"\n";
	print fhBATCHFILE "\"VERSION\"=\"$version\"\n";
	print fhBATCHFILE "\"VERSIONDATE\"=\"$timestamp\"\n";
	print fhBATCHFILE "\"YEAR\"=\"$hryear\"\n";
	print fhBATCHFILE "\"YEARPLUS2\"=\"$hryearplus2\"\n";
	close (fhBATCHFILE);

# Display the results to the screen
# ---------------------------------
	print "\nBATCH -> $batch\n";
	print "\nDAY -> $hrdaystamp\n";
	print "\nDAY_OF_YEAR -> $mydoy\n";
	print "\nMONTH -> $hrmonth\n";	
	print "\nSUBVERSION -> $mySubversion\n";
	print "\nTIMESTAMP -> $timestamp\n";	
	print "\nVERSION -> $version\n";
	print "\nVERSIONDATE -> $timestamp\n";	
	print "\nYEAR -> $hryear\n";
	print "\nYEARPLUS2 -> $hryearplus2\n";
    print "\n==>INFO: END\n";
