#!usr/bin/perl 
########################################################################
#                                                                      #
# Created:      01/04/2005                                             #
# Author:       John                                                   #
# Contact:      support@hrcompletemanager.com                          #
# Purpose:      Deletes all files older than a given number of days    #
#                                                                      #
#               This script is based on the standard docs              #
#               of File::Find                                          #
#                                                                      #
# Copyright:    hrcompletemanager.com 2022                            #
#               This is free software. Do with is what you wish. It    #
#               comes with no guarantees or warranties. The  author is #
#               not responsible for anything. If you use it and find   #
#               it useful then a thank you would be nice. If you       #
#               use it to make a lot of money then congratulations.    #
#                                                                      #
# WARNING:      WE USE THIS PROGRAM A LOT                              #
#               IT DOES MORE OR LESS EXACTLY WHAT WE WANT              #
#               IT MAY NOT BE SUITABLE FOR YOU                         #
#               USE IT AT YOUR OWN RISK                                #
#                                                                      #
########################################################################

=head1 DESCRIPTION

This utility deletes all files older than a certain number of days.

It deletes recursively from the path name specified in the first argument
of the command line. It can be configured to be hard coded for a specific
path (SEE USER CONFIGURABLE SECTION).

It deletes all files that are older than the number of days specified
in the second argument of the command line. It can be configured to be 
hard coded for a specific number of days (SEE USER CONFIGURABLE SECTION)
=cut

use strict;
use warnings;
use File::Find;

#=======================================================================
# USER CONFIGURABLE SECTION
#=======================================================================
# You may need to edit section for your own configuration
#
my $PATH  	  = "$ARGV[0]";  # Hard code the path or use the 1st argument
my $DAYS  	  = "$ARGV[1]";  # Hard code the age or use the second argument
#=======================================================================
# END OF USER CONFIGURABLE SECTION
#=======================================================================
finddepth (\&wanted, $PATH);
    sub wanted {
        return if /^\.\.?/;
        if ((-M $_) >= $DAYS) { unlink $File::Find::name; }
    }
